//-Normal State-----------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Normal Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeNormal::OnEnter(%this,%cmpAI)
{
   echo("Home Normal");
   
   // Reset lost happiness
   RestoreLostHappinessFromHome(%cmpAI);
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Normal Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeNormal::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Normal Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeNormal::Update(%this,%cmpAI)
{
   AICheckHomeForFire(%cmpAI);
   
   // Go to stage one
   if(IsHomeless(%cmpAI) && AreMonitoringHome()) {
      ReturnValue(%cmpAI, 0);
   }
   
   // Stay normal
   else {
      ReturnValue(%cmpAI, -1);
   }
   return;
}
//------------------------------------------------------------------------------


//-Stage One--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage One Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage1::OnEnter(%this,%cmpAI)
{
   echo("Home Stage One");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage One Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage1::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage One Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage1::Update(%this,%cmpAI)
{
   AICheckHomeForFire(%cmpAI);
   
   // Found a home   
   if(!IsHomeless(%cmpAI) || !AreMonitoringHome()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.homelessWaitTimes_0;
   
   // Go to stage two
   if(TimeInNode(%cmpAI) >= %totalTime) {
      // Test protesting
      %percent = %datablock.homelessProtestPercent;
      %happy   = %datablock.homelessProtestHappyMod;
      if(CheckForMonitorEffect(%percent, %happy, 0)) {
         // Start protesting
         %cmpChar = slgQueryInterface(GetThisObject(%cmpAI), $CID_CHARACTER);
         %cmpChar.protestHome();
      }
      ReturnValue(%cmpAI,1);
   }
   
   // Stay in stage one
   else {
      ReturnValue(%cmpAI,-1);
   }
   
   return;
}
//------------------------------------------------------------------------------


//-Stage Two--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Two Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage2::OnEnter(%this,%cmpAI)
{
   echo("Home Stage Two");
   
   // Lose happiness from homelessness
   LoseHappinessFromHome(%cmpAI);
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Two Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage2::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Two Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage2::Update(%this,%cmpAI)
{
   AICheckHomeForFire(%cmpAI);
   
   // Found a home   
   if(!IsHomeless(%cmpAI) || !AreMonitoringHome()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.homelessWaitTimes_1;
   
   // Become drunk or go to stage three
   if(TimeInNode(%cmpAI) >= %totalTime) {
      // Test drunk
      %percent = %datablock.homelessDrunkPercent;
      %happy   = %datablock.homelessDrunkHappyMod;
      if(CheckForMonitorEffect(%percent, %happy, 0) && TeamBuildingExists(%cmpAI,"Saloon")) {
         ReturnValue(%cmpAI,2);
      }
      
      // Go to stage three
      else {
         ReturnValue(%cmpAI,1);
      }
   }
   
   // Stay in stage two   
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------


//-Stage Three------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Three Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage3::OnEnter(%this,%cmpAI)
{
   echo("Home Stage Three");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage3::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage3::Update(%this,%cmpAI)
{
   AICheckHomeForFire(%cmpAI);
   
   // Found a home   
   if(!IsHomeless(%cmpAI) || !AreMonitoringHome()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.homelessWaitTimes_2;
   
   // Go to stage four and test protest
   if(TimeInNode(%cmpAI) >= %totalTime) {
      // Test protesting
      %percent = %datablock.homelessProtestPercent;
      %happy   = %datablock.homelessProtestHappyMod;
      if(CheckForMonitorEffect(%percent, %happy, 1)) {
         // Start protesting
         %cmpChar = slgQueryInterface(GetThisObject(%cmpAI), $CID_CHARACTER);
         %cmpChar.protestHome();
      }
      ReturnValue(%cmpAI,1);
   }
   
   // Stay in stage three
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------


//-Stage Four-------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Four Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage4::OnEnter(%this,%cmpAI)
{
   echo("Home Stage Four");
   
   // Update the happiness for the character
   LoseHappinessFromHome(%cmpAI);
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Four Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage4::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Four Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage4::Update(%this,%cmpAI)
{
   AICheckHomeForFire(%cmpAI);
   
   // Found home
   if(!IsHomeless(%cmpAI) || !AreMonitoringHome()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.homelessWaitTimes_3;
   
   // Go to stage five or leave town
   if(TimeInNode(%cmpAI) >= %totalTime) {
      // Test leave town
      %percent = %datablock.homelessLeavePercent;
      %happy   = %datablock.homelessLeaveHappyMod;
      if(CheckForMonitorEffect(%percent, %happy, 0)) {
         %msg = slgGetUIString("id_character_homelessleave");
         %msg = slgFormatUIString(%msg, GetThisObject(%cmpAI).name);
         commandToClient(ClientGroup.getObject(0), 'SendHudMessage', %msg);
         %cmpAI.performAction("leave");
         ReturnValue(%cmpAI,2);
      }
            
      // Go to stage five
      else {
         ReturnValue(%cmpAI,1);
      }
   }
   
   // Stay in stage four
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------


//-Stage Five-------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Five Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage5::OnEnter(%this,%cmpAI)
{
   echo("Home Stage Five");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Five Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage5::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Five Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHomeStage5::Update(%this,%cmpAI)
{
   AICheckHomeForFire(%cmpAI);
   
   // Found home
   if(!IsHomeless(%cmpAI) || !AreMonitoringHome()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.homelessWaitTimes_4;
   
   // Leave town
   if(TimeInNode(%cmpAI) >= %totalTime) {
      %msg = slgGetUIString("id_character_homelessleave");
      %msg = slgFormatUIString(%msg, GetThisObject(%cmpAI).name);
      commandToClient(ClientGroup.getObject(0), 'SendHudMessage', %msg);
      %cmpAI.performAction("leave");
      ReturnValue(%cmpAI,1);
   }
   
   // Stay in stage five
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------

function AICheckHomeForFire(%data)
{
   if (isObject(%data) == false)
   {
      return;
   }
   
   // if there are actions to perform, this character
   // should not cancel them to put out a fire
   if (%data.getActionCount() > 0)
   {
      return;
   }
   
   // if the is selected, do not force fire fighting
   %object = GetThisObject(%data);
   if (slgIsSelected(%object) == true)
   {
      return;
   }
   
   // ensure that this is a character
   %character = slgQueryInterface(%object, $CID_CHARACTER);
   if (isObject(%character) == false)
   {
      return;
   }
   
   // before checking if the character's home is on fire, make
   // sure the character has a home
   if (%character.hasHome() == false)
   {
      return;
   }
   
   // get the home of the character
   %home = %character.getHome();
   %building = slgQueryInterface(%home, $CID_BUILDING);
   if (isObject(%building) == false)
   {
      return;
   }

   // check if the home is on fire   
   if (%building.onFire() == true)
   {
      %data.performAction("fightfire", %home);
   }
}

// End MonitorHome.cs
